from django.db.models import Manager

from .category_group_queryset import CategoryGroupQuerySet

class CategoryGroupManager(Manager):
    """
    Manages operations related to CategoryGroup objects.

    Provides an interface for performing queries or actions that are
    specific to category groups. This class extends the base Manager
    class and may offer additional functionality to handle specific
    business logic or database operations related to category grouping.
    """
    def get_queryset(self) -> CategoryGroupQuerySet:
        return CategoryGroupQuerySet(
            model=self.model,
            using=self._db,
        )

    def with_total_categories(self) -> CategoryGroupQuerySet:
        """
        Add `total_categories=int` field to queryset.
        :return: CategoryGroupQuerySet
        """
        return self.get_queryset().with_total_categories()

    def with_annotations(self) -> CategoryGroupQuerySet:
        """
        Applies with_total_categories method to queryset.
        :return: CategoryGroupQuerySet
        """
        return self.get_queryset().with_annotations()
