from django.db.models import Manager
from .article_queryset import ArticleQuerySet


class ArticleManager(
    Manager,
):
    def get_queryset(
        self,
    ) -> ArticleQuerySet:
        return ArticleQuerySet(
            self.model,
            using=self._db,
        )

    def with_annotations(self) -> ArticleQuerySet:
        return self.get_queryset().with_annotations()
