# django-userguide

### Installation

```python
INSTALLED_APPS = [
    'userguide',
]

#
# Markdown editor in Django Admin Site
#

X_FRAME_OPTIONS = "SAMEORIGIN"

MDEDITOR_CONFIGS = {
    'default': {
        'language': 'en',
    }
}
```

### Application settings

```python
# Example settings

# Default size of the truncated string length to use in some serializers.
# Please be aware that, if the string exceeds max length, an extra '...' will be concatenated.
USER_GUIDE_STRING_TRUNCATE_LENGTH = 25

# Permission classes to use in view sets.
# It's not required (Default to []).
# Permission classes must be a list of strings to be imported dynamically in BaseViewSet.
USER_GUIDE_PERMISSION_CLASSES = []

# Authentication classes to use in view sets.
# It's not required (Default to []).
# Authentication classes must be a list of strings to be imported dynamically in BaseViewSet.
USER_GUIDE_AUTHENTICATION_CLASSES = []
```